/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.legacy;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import net.sixik.sdmshoprework.SDMShopClient;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.client.screen.basic.AbstractShopScreen;
import net.sixik.sdmshoprework.client.screen.basic.widget.AbstractShopEntryButton;
import net.sixik.sdmshoprework.client.screen.legacy.LegacyShopEntriesPanel;
import net.sixik.sdmshoprework.client.screen.legacy.LegacyShopMoneyPanel;
import net.sixik.sdmshoprework.client.screen.legacy.LegacyShopTabPanel;
import net.sixik.sdmshoprework.client.screen.legacy.createEntry.LegacyCreateEntryScreen;
import net.sixik.sdmshoprework.client.screen.legacy.widget.LegacyShopEntryButton;
import net.sixik.sdmshoprework.client.screen.legacy.widget.LegacyShopTabButton;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.v2.utils.math.Vector2;

public class LegacyShopScreen
extends AbstractShopScreen {
    public PanelScrollBar tabsScrollPanel;
    public PanelScrollBar entryScrollPanel;
    public Vector2 entryButtonSize = new Vector2(48, 48);

    public LegacyShopScreen(boolean isOpenCommand) {
        super(isOpenCommand);
    }

    public void addWidgets() {
        this.entriesPanel = new LegacyShopEntriesPanel((Panel)this);
        this.add((Widget)this.entriesPanel);
        this.entryScrollPanel = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.entriesPanel){

            public void drawScrollBar(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                SDMShopClient.getTheme().getShadow().draw(graphics, x + 1, y + 1, w - 2, h - 2);
                GuiHelper.drawHollowRect((PoseStack)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)SDMShopClient.getTheme().getReact(), (boolean)false);
            }

            public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                SDMShopClient.getTheme().getStoke().draw(graphics, x, y, w, h);
            }
        };
        this.add((Widget)this.entryScrollPanel);
        this.tabsPanel = new LegacyShopTabPanel((Panel)this);
        this.add((Widget)this.tabsPanel);
        this.tabsScrollPanel = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.tabsPanel){

            public void drawScrollBar(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                SDMShopClient.getTheme().getShadow().draw(graphics, x + 1, y + 1, w - 2, h - 2);
                GuiHelper.drawHollowRect((PoseStack)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)SDMShopClient.getTheme().getReact(), (boolean)false);
            }

            public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                SDMShopClient.getTheme().getStoke().draw(graphics, x, y, w, h);
            }
        };
        this.add((Widget)this.tabsScrollPanel);
        this.moneyPanel = new LegacyShopMoneyPanel((Panel)this);
        this.add((Widget)this.moneyPanel);
        this.tabsScrollPanel.setScrollStep(19.0);
        this.entryScrollPanel.setScrollStep(19.0);
        this.setProperties();
    }

    @Override
    public void openCreateScreen() {
        new LegacyCreateEntryScreen(this).openGui();
    }

    @Override
    public void setProperties() {
        Vector2 size = new Vector2(this.width / 4, this.height);
        Vector2 additionSize = new Vector2(this.width - size.x, this.height / 8);
        int pos = size.x;
        this.tabsPanel.setY(additionSize.y);
        this.tabsPanel.setSize(size.x, size.y - additionSize.y - 1);
        this.tabsPanel.alignWidgets();
        this.moneyPanel.setSize(size.x, additionSize.y);
        this.entriesPanel.setX(pos);
        this.entriesPanel.setSize(this.width - size.x, size.y);
        this.tabsScrollPanel.setPosAndSize(this.tabsPanel.posX + this.tabsPanel.width - this.getScrollbarWidth(), this.tabsPanel.posY, this.getScrollbarWidth(), this.tabsPanel.height);
        this.entryScrollPanel.setPosAndSize(this.entriesPanel.posX + this.entriesPanel.width - this.getScrollbarWidth(), this.entriesPanel.posY, this.getScrollbarWidth(), this.entriesPanel.height);
        this.addTabsButtons();
        this.addEntriesButtons();
    }

    @Override
    public void addEntriesButtons() {
        if (this.selectedTab != null) {
            ArrayList<AbstractShopEntryButton> widgets = new ArrayList<AbstractShopEntryButton>();
            for (AbstractShopEntry abstractShopEntry : this.selectedTab.getTabEntry()) {
                if (abstractShopEntry.isLocked() && !SDMShopR.isEditMode()) continue;
                LegacyShopEntryButton button = new LegacyShopEntryButton(this.entriesPanel, abstractShopEntry);
                button.setSize(this.entryButtonSize.x, this.entryButtonSize.y);
                widgets.add(button);
            }
            if (SDMShopR.isEditMode()) {
                LegacyShopEntryButton button = new LegacyShopEntryButton(this.entriesPanel, null);
                button.setSize(this.entryButtonSize.x, this.entryButtonSize.y);
                button.setEdit();
                widgets.add(button);
            }
            this.calculatePositions(widgets);
            this.entriesPanel.widgets.clear();
            this.entriesPanel.addAll(widgets);
            this.entryScrollPanel.setValue(0.0);
        }
    }

    @Override
    public void calculatePositions(List<AbstractShopEntryButton> entryButtons) {
        int maxElementsOnScreen = this.getCountInArray();
        int x = this.getStartPosX(this.getCountInArray());
        int y = 2;
        for (int i = 0; i < entryButtons.size(); ++i) {
            AbstractShopEntryButton shopEntryButton = entryButtons.get(i);
            if (i > 0) {
                if (i % maxElementsOnScreen == 0) {
                    y += this.entryButtonSize.y + 6;
                    x = this.getStartPosX(this.getCountInArray());
                } else {
                    x += this.entryButtonSize.x + 3;
                }
                shopEntryButton.setPos(x, y);
                continue;
            }
            shopEntryButton.setPos(x, y);
        }
    }

    public int getCountInArray() {
        int x1 = 0;
        int x = this.entryButtonSize.x;
        for (int i = 0; i < 1000; ++i) {
            x1 = x * i + 3 * i;
            if (x1 <= this.entriesPanel.width) continue;
            return i - 1;
        }
        return 0;
    }

    public int getStartPosX(int count) {
        int x = this.entryButtonSize.x;
        int x1 = 0;
        for (int i = 0; i < count + 1; ++i) {
            x1 = x * i + 3 * i;
        }
        return this.entriesPanel.width / 2 - x1 / 2;
    }

    @Override
    public void addTabsButtons() {
        ArrayList<LegacyShopTabButton> widgetList = new ArrayList<LegacyShopTabButton>();
        int y = 2;
        for (ShopTab shopTab : ShopBase.CLIENT.getShopTabs()) {
            LegacyShopTabButton button = new LegacyShopTabButton(this.tabsPanel, shopTab);
            button.setSize(this.tabsPanel.width - 3 - this.getScrollbarWidth(), 18);
            button.setPos(2, y);
            widgetList.add(button);
            y += 24;
        }
        if (SDMShopR.isEditMode()) {
            LegacyShopTabButton button = new LegacyShopTabButton(this.tabsPanel, null);
            button.setSize(this.tabsPanel.width - 3 - this.getScrollbarWidth(), 18);
            button.setPos(2, y);
            button.setEdit();
            widgetList.add(button);
        }
        this.tabsPanel.widgets.clear();
        this.tabsPanel.addAll(widgetList);
        this.tabsScrollPanel.setValue(0.0);
    }

    protected int getScrollbarWidth() {
        return 4;
    }
}

